# Módulo de Cartera - Sistema Faleyi

## Descripción
Este módulo implementa una gestión completa de cartera para el sistema de ventas, permitiendo el control de deudas de clientes, registro de abonos y seguimiento de pagos pendientes.

## Características Implementadas

### ✅ Funcionalidades Principales
- **Gestión automática de cartera**: Se crea automáticamente cuando una venta tiene deuda
- **Registro de abonos**: Sistema para registrar pagos parciales o completos
- **Seguimiento de deudas**: Control detallado de saldos pendientes
- **Filtros avanzados**: Por estado, cliente, fechas
- **Reportes detallados**: Vista completa de cartera por cliente

### ✅ Mejoras Técnicas
- **Arquitectura de servicios**: Separación de lógica de negocio
- **Transacciones de base de datos**: Garantía de integridad de datos
- **Validaciones robustas**: Control de errores y validaciones
- **Relaciones optimizadas**: Mejores consultas a base de datos

## Instalación y Configuración

### 1. Ejecutar Migraciones
```bash
php artisan migrate
```

### 2. Verificar Modelos
Los siguientes modelos han sido actualizados:
- `Venta.php` - Agregados campos de pago
- `Cartera.php` - Relaciones mejoradas
- `DetalleCartera.php` - Relaciones optimizadas

### 3. Servicios Creados
- `CarteraService.php` - Lógica principal de cartera

### 4. Controladores Actualizados
- `VentaController.php` - Integración con cartera
- `CarteraController.php` - Funcionalidades completas

### 5. Rutas Agregadas
```php
// Nuevas rutas de cartera
Route::get('/cartera/selectCliente', 'CarteraController@selectCliente');
Route::get('/cartera/resumenCliente', 'CarteraController@obtenerResumenCliente');
Route::post('/cartera/registrarAbono', 'CarteraController@registrarAbono');
Route::get('/cartera/detalle/{id}', 'CarteraController@obtenerDetalle');
```

## Uso del Sistema

### Proceso de Venta con Deuda
1. **Crear venta**: Al registrar una venta, especificar el monto pagado
2. **Cartera automática**: Si hay deuda, se crea automáticamente el registro de cartera
3. **Seguimiento**: El sistema mantiene control de saldos pendientes

### Gestión de Abonos
1. **Acceder a cartera**: Ir al módulo de cartera
2. **Seleccionar deuda**: Elegir la cartera a la que registrar abono
3. **Registrar abono**: Ingresar monto y observaciones
4. **Actualización automática**: El sistema actualiza saldos automáticamente

### Filtros Disponibles
- **Por estado**: Pendiente, Parcial, Pagado
- **Por cliente**: Búsqueda específica de cliente
- **Por fechas**: Rango de fechas de venta
- **Paginación**: Navegación por páginas

## Estructura de Base de Datos

### Tabla `ventas` (actualizada)
```sql
ALTER TABLE ventas ADD COLUMN monto_pagado DECIMAL(11,2) DEFAULT 0;
ALTER TABLE ventas ADD COLUMN monto_deuda DECIMAL(11,2) DEFAULT 0;
ALTER TABLE ventas ADD COLUMN metodo_pago ENUM('Efectivo','Tarjeta','Transferencia','Credito') DEFAULT 'Efectivo';
```

### Tabla `cartera` (nueva)
```sql
CREATE TABLE cartera (
    id INT PRIMARY KEY AUTO_INCREMENT,
    cliente_id INT,
    idventa_cart INT,
    total_deuda DECIMAL(11,2) DEFAULT 0,
    compras DECIMAL(11,2) DEFAULT 0,
    cuotas INT DEFAULT 1,
    fecha_compr_pago DATE,
    total_abono DECIMAL(11,2) DEFAULT 0,
    descuento DECIMAL(11,2) DEFAULT 0,
    devolucion DECIMAL(11,2) DEFAULT 0,
    saldo_actual DECIMAL(11,2) DEFAULT 0,
    estado_cart ENUM('Pendiente','Pagado','Parcial') DEFAULT 'Pendiente',
    observaciones TEXT,
    created_at TIMESTAMP,
    updated_at TIMESTAMP
);
```

### Tabla `detalle_cartera` (nueva)
```sql
CREATE TABLE detalle_cartera (
    id INT PRIMARY KEY AUTO_INCREMENT,
    idcartera INT,
    articulo_id INT,
    centrocosto_id INT,
    valor_venta_articulo DECIMAL(11,2),
    cantidad INT DEFAULT 1,
    compra DECIMAL(11,2),
    fecha_venta DATE,
    pago_incompl DECIMAL(11,2) DEFAULT 0,
    deuda DECIMAL(11,2) DEFAULT 0,
    abono DECIMAL(11,2) DEFAULT 0,
    fecha_abono DATE,
    descuento DECIMAL(11,2) DEFAULT 0,
    devolucion DECIMAL(11,2) DEFAULT 0,
    saldo_actual DECIMAL(11,2) DEFAULT 0,
    created_at TIMESTAMP,
    updated_at TIMESTAMP
);
```

## Componentes Vue

### Venta.vue (actualizado)
- Campos de método de pago
- Campo de monto pagado
- Cálculo automático de deuda
- Validaciones mejoradas

### CarteraMejorada.vue (nuevo)
- Interfaz completa de gestión de cartera
- Filtros avanzados
- Registro de abonos
- Vista detallada de cartera

## Validaciones Implementadas

### En Ventas
- Monto pagado no puede ser negativo
- Monto pagado no puede ser mayor al total
- Validación de stock disponible
- Validación de cliente seleccionado

### En Cartera
- Validación de monto de abono
- Control de saldos pendientes
- Verificación de estado de cartera

## Notas Importantes

1. **Backup**: Siempre hacer backup antes de ejecutar migraciones
2. **Testing**: Probar en ambiente de desarrollo primero
3. **Datos existentes**: Las ventas existentes tendrán monto_pagado = total por defecto
4. **Permisos**: Verificar que los usuarios tengan permisos para acceder al módulo

## Soporte

Para problemas o consultas sobre el módulo de cartera, revisar:
1. Logs de Laravel (`storage/logs/laravel.log`)
2. Errores de consola del navegador
3. Respuestas de las APIs en Network tab

## Próximas Mejoras Sugeridas

- [ ] Reportes PDF de cartera
- [ ] Notificaciones de deudas vencidas
- [ ] Integración con sistema de cobranza
- [ ] Dashboard de cartera con gráficos
- [ ] Exportación a Excel 