# Configuración del Menú de Cartera

## Para agregar el menú de "Gestión de Cartera" al sistema:

### 1. Agregar al menú principal
Busca el archivo de menú principal (probablemente en `resources/views/layouts/app.blade.php` o similar) y agrega:

```html
<li class="nav-item">
    <a class="nav-link" href="/gestion-cartera">
        <i class="fa fa-credit-card"></i>
        <span>Gestión de Cartera</span>
    </a>
</li>
```

### 2. Agregar la ruta principal
En `routes/web.php`, agrega esta ruta dentro del grupo de middleware correspondiente:

```php
Route::get('/gestion-cartera', function () {
    return view('gestion-cartera');
})->name('gestion-cartera');
```

### 3. Crear la vista principal
Crear el archivo `resources/views/gestion-cartera.blade.php`:

```php
@extends('layouts.app')

@section('content')
<div id="app">
    <gestion-cartera></gestion-cartera>
</div>
@endsection
```

### 4. Registrar el componente Vue
En `resources/assets/js/app.js`, agrega:

```javascript
Vue.component('gestion-cartera', require('./components/GestionCartera.vue').default);
```

### 5. Compilar los assets
Ejecutar:
```bash
npm run dev
```

## Funcionalidades incluidas:

✅ **Panel de Resumen**
- Total deudas
- Total abonado
- Saldo pendiente
- Carteras activas

✅ **Filtros Avanzados**
- Por estado (Pendiente, Parcial, Pagado)
- Por cliente
- Por fechas

✅ **Lista de Carteras**
- Información completa de cada cartera
- Estados visuales con badges
- Paginación

✅ **Registro de Abonos**
- Modal profesional para registrar abonos
- Validación de montos
- Métodos de pago
- Observaciones

✅ **Vista de Detalles**
- Detalle completo de cada cartera
- Desglose por artículo
- Información financiera

✅ **Reportes PDF**
- Generación de reportes en PDF
- Información completa de cartera

## Permisos recomendados:
- Solo usuarios con rol de Administrador o Vendedor
- Verificar permisos antes de mostrar el menú

## Notas importantes:
- El componente usa Bootstrap 4 y Font Awesome
- Requiere jQuery para los modales
- Compatible con el diseño actual del sistema 