<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Articulo extends Model
{
    protected $table = 'articulos';
    protected $primaryKey = 'id';
    protected $fillable =[
        'idcategoria',
        'idmarca',
        'codigo',
        'nombre',
        'referencia',
        'tipo_articulo_id',
        'talla_id',
        'color_id',
        'centrocosto_id',
        'material',        
        'precio_venta',
        'stock',
        'descripcion',
        'condicion'
    ];
    public function categoria(){
        return $this->belongsTo('App\Categoria');
    }
    public function tipo_articulo(){
        return $this->belongsTo('App\TipoArticulo');
    }
    public function marca(){
        return $this->belongsTo('App\Marca');
    }
    public function talla(){
        return $this->belongsTo('App\Talla');
    }
    public function color(){
        return $this->belongsTo('App\Color');
    }
    public function centrocosto(){
        return $this->belongsTo('App\CentroCosto');
    }
}
