<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Cartera extends Model
{
    protected $table = 'cartera';
    protected $primaryKey = 'id';
    protected $fillable =[
        'cliente_id',
        'idventa_cart', 
        'total_deuda',
        'compras',
        'cuotas',
        'fecha_compr_pago',
        'total_abono',
        'descuento',
        'devolucion',
        'saldo_actual',
        'estado_cart'
        // 'observaciones'
    ];
    public $timestamps = true;

    public function venta(){
        return $this->belongsTo(Venta::class, 'idventa_cart');
    }
    
    public function cliente(){
        return $this->belongsTo(Persona::class, 'cliente_id');
    }
    
    public function detalles(){
        return $this->hasMany(DetalleCartera::class, 'idcartera');
    }
      
}