<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DetalleCartera extends Model
{
    protected $table = 'detalle_cartera';
    protected $primaryKey = 'id';
    protected $fillable = [
        'idcartera',
        'articulo_id',
        'centrocosto_id',
        'valor_venta_articulo',
        'cantidad',
        'compra',
        'fecha_venta',
        'pago_incompl', 
        'deuda',
        'abono',
        'fecha_abono',
        'descuento',
        'devolucion',
        'saldo_actual'
    ];
    public $timestamps = true;

    public function articulo(){
        return $this->belongsTo(Articulo::class, 'articulo_id');
    }
    
    public function cartera(){
        return $this->belongsTo(Cartera::class, 'idcartera');
    }
    
    public function centrocosto(){
        return $this->belongsTo(CentroCosto::class, 'centrocosto_id');
    }
}