<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DetalleVenta extends Model
{
    protected $table = 'detalle_ventas';
    protected $primaryKey = 'id';
    protected $fillable = [
        'idventa', 
        'idarticulo',
        'cantidad',
        'precio',
        'descuento'
    ];
    public $timestamps = false;
    
    // Relación inversa: un detalle pertenece a una venta
    public function venta()
    {
        return $this->belongsTo(Venta::class, 'idventa');
    }
}
