<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use App\Ingreso;
use App\DetalleIngreso;
use App\User;
use App\Notifications\NotifyAdmin;


class IngresoController extends Controller
{
    public function index(Request $request)
    {
        if (!$request->ajax()) return redirect('/');

        $buscar = $request->buscar;
        $criterio = $request->criterio;
        
        if ($buscar==''){
            $ingresos = Ingreso::join('personas','ingresos.idproveedor','=','personas.id')
            ->join('users','ingresos.idusuario','=','users.id')
            ->join('detalle_ingresos','ingresos.id','=','detalle_ingresos.idingreso')
            ->join('articulos','detalle_ingresos.idarticulo','=','articulos.id')
            ->join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
            ->join('talla','articulos.talla_id','=','talla.id')
            ->join('color','articulos.color_id','=','color.id')
            ->join('marca','articulos.idmarca','=','marca.id')
            ->select('ingresos.id','ingresos.tipo_comprobante','ingresos.serie_comprobante',
            'ingresos.num_comprobante','ingresos.fecha_hora','ingresos.impuesto','ingresos.total',
            'ingresos.estado','personas.nombre','users.usuario','articulos.nombre as nombreArt',
            'tipo_articulo.nombre as nombreTipArt','articulos.codigo','articulos.referencia',
            'talla.talla','color.color','detalle_ingresos.cantidad','detalle_ingresos.precio',
            'marca.nombre as nombreMar','articulos.centrocosto_id as idCC')
            ->orderBy('ingresos.id', 'desc')->paginate(10);
        }
        else{
            $ingresos = Ingreso::join('personas','ingresos.idproveedor','=','personas.id')
            ->join('users','ingresos.idusuario','=','users.id')
            ->join('detalle_ingresos','ingresos.id','=','detalle_ingresos.idingreso')
            ->join('articulos','detalle_ingresos.idarticulo','=','articulos.id')
            ->join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
            ->join('talla','articulos.talla_id','=','talla.id')
            ->join('color','articulos.color_id','=','color.id')
            ->join('marca','articulos.idmarca','=','marca.id')
            ->where('ingresos.tipo_comprobante'.$criterio, 'like', '%'. $buscar . '%')
            ->orWhere('ingresos.serie_comprobante'.$criterio, 'like', '%'. $buscar . '%')
            ->orWhere('ingresos.num_comprobante'.$criterio, 'like', '%'. $buscar . '%')
            ->orWhere('articulos.codigo'.$criterio, 'like', '%'. $buscar . '%')
            ->orWhere('articulos.articulo'.$criterio, 'like', '%'. $buscar . '%')
            //->where('ingresos.'.$criterio, 'like', '%'. $buscar . '%')
            //->orWhere('ingresos.'.$criterio, 'like', '%'. $buscar . '%')
            //->orderBy('detalle_ingresos.id', 'desc')
            ->orderBy('ingresos.id', 'desc')
            ->select('ingresos.id','ingresos.tipo_comprobante','ingresos.serie_comprobante',
            'ingresos.num_comprobante','ingresos.fecha_hora','ingresos.impuesto','ingresos.total',
            'ingresos.estado','personas.nombre','users.usuario','articulos.nombre as nombreArt',
            'tipo_articulo.nombre as nombreTipArt','articulos.codigo','articulos.referencia',
            'talla.talla','color.color','detalle_ingresos.cantidad','detalle_ingresos.precio',
            'marca.nombre as nombreMar','articulos.centrocosto_id as idCC')
            ->paginate(10);

        }
        
        return [
            'pagination' => [
                'total'        => $ingresos->total(),
                'current_page' => $ingresos->currentPage(),
                'per_page'     => $ingresos->perPage(),
                'last_page'    => $ingresos->lastPage(),
                'from'         => $ingresos->firstItem(),
                'to'           => $ingresos->lastItem(),
            ],
            'ingresos' => $ingresos
        ];
    }
    
    public function detalleingreso(Request $request)
    {
        
            $ingresos = Ingreso::join('personas','ingresos.idproveedor','=','personas.id')
            ->join('users','ingresos.idusuario','=','users.id')
            ->join('detalle_ingresos','ingresos.id','=','detalle_ingresos.idingreso')
            ->join('articulos','detalle_ingresos.idarticulo','=','articulos.id')
            ->join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
            ->join('talla','articulos.talla_id','=','talla.id')
            ->join('color','articulos.color_id','=','color.id')
            ->join('marca','articulos.idmarca','=','marca.id')
            ->join('centrocosto','articulos.centrocosto_id','=','centrocosto.id')
            ->select('ingresos.id','ingresos.tipo_comprobante','ingresos.serie_comprobante',
            'ingresos.num_comprobante','ingresos.fecha_hora','ingresos.impuesto','ingresos.total',
            'ingresos.estado','personas.nombre','users.usuario','articulos.nombre as nombreArt',
            'tipo_articulo.nombre as nombreTipArt','articulos.codigo','articulos.referencia',
            'talla.talla','color.color','detalle_ingresos.cantidad','detalle_ingresos.precio',
            'marca.nombre as nombreMar','articulos.centrocosto_id as idCC','centrocosto.nombre as nombreCC')
            ->where('ingresos.estado','=','Registrado')
            ->orderBy('ingresos.id', 'desc')
            //->paginate(10);
            ->get();
            
            return view('contenido.detalleingreso', compact('ingresos'));

    }

    public function obtenerCabecera(Request $request){
        if (!$request->ajax()) return redirect('/');

        $id = $request->id;
        $ingreso = Ingreso::join('personas','ingresos.idproveedor','=','personas.id')
        ->join('users','ingresos.idusuario','=','users.id')
        ->select('ingresos.id','ingresos.tipo_comprobante','ingresos.serie_comprobante',
        'ingresos.num_comprobante','ingresos.fecha_hora','ingresos.impuesto','ingresos.total',
        'ingresos.estado','personas.nombre','users.usuario')
        ->where('ingresos.id','=',$id)
        ->orderBy('ingresos.id', 'desc')->take(1)->get();
        
        return ['ingreso' => $ingreso];
    }
    public function obtenerDetalles(Request $request){
        if (!$request->ajax()) return redirect('/');

        $id = $request->id;
        $detalles = DetalleIngreso::join('articulos','detalle_ingresos.idarticulo','=','articulos.id')
            ->join('categorias','articulos.idcategoria','=','categorias.id')
            ->join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
            ->join('talla','articulos.talla_id','=','talla.id')
            ->join('color','articulos.color_id','=','color.id')
            ->join('marca','articulos.idmarca','=','marca.id')
            ->join('centrocosto','articulos.centrocosto_id','=','centrocosto.id')
            ->select('articulos.nombre as articulo',
            'tipo_articulo.nombre as nombreTipArt','articulos.codigo','articulos.referencia',
            'talla.talla','color.color','detalle_ingresos.cantidad','detalle_ingresos.precio',
            'marca.nombre as nombreMar','articulos.centrocosto_id as idCC','categorias.nombre as nombreCat',
            'articulos.stock','centrocosto.nombre as nombreCC')
            ->where('detalle_ingresos.idingreso','=',$id)
            ->orderBy('detalle_ingresos.id', 'desc')->get();
        
        return ['detalles' => $detalles];
    }

    public function store(Request $request)
    {
        if (!$request->ajax()) return redirect('/');

        try{
            DB::beginTransaction();

            $mytime= Carbon::now('America/Lima');

            $ingreso = new Ingreso();
            $ingreso->idproveedor = $request->idproveedor;
            $ingreso->idusuario = \Auth::user()->id;
            $ingreso->tipo_comprobante = $request->tipo_comprobante;
            $ingreso->serie_comprobante = $request->serie_comprobante;
            $ingreso->num_comprobante = $request->num_comprobante;
            $ingreso->fecha_hora = $mytime->toDateString();
            $ingreso->impuesto = $request->impuesto;
            $ingreso->total = $request->total;
            $ingreso->estado = 'Registrado';
            $ingreso->save();

            $detalles = $request->data;//Array de detalles
            //Recorro todos los elementos

            foreach($detalles as $ep=>$det)
            {
                $detalle = new DetalleIngreso();
                $detalle->idingreso = $ingreso->id;
                $detalle->idarticulo = $det['idarticulo'];
                $detalle->cantidad = $det['cantidad'];
                $detalle->precio = $det['precio'];          
                $detalle->save();
            }

            $fechaActual= date('Y-m-d');
        $numVentas = DB::table('ventas')->whereDate('created_at', $fechaActual)->count();
        $numIngresos = DB::table('ingresos')->whereDate('created_at',$fechaActual)->count();

        $arregloDatos = [
            'ventas' => [
                        'numero' => $numVentas,
                        'msj' => 'Ventas'
            ],
            'ingresos' => [
                        'numero' => $numIngresos,
                        'msj' => 'Ingresos'
            ]
            ];

            $allUsers = User::all();

            foreach ($allUsers as $notificar) {
                User::findOrFail($notificar->id)->notify(new NotifyAdmin($arregloDatos));
            }


            DB::commit();
        } catch (Exception $e){
            DB::rollBack();
        }
    }

    public function desactivar(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $ingreso = Ingreso::findOrFail($request->id);
        $ingreso->estado = 'Anulado';
        $ingreso->save();
    }
}
