<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
//use Illuminate\Support\Facades\DB;
use App\Talla;

class TallaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if (!$request->ajax()) return redirect('/');

        $buscar = $request->buscar;
        $criterio = $request->criterio;
        
        if ($buscar==''){
            $tallas = Talla::orderBy('id', 'desc')->paginate(10);
        }
        else{
            $tallas = Talla::where($criterio, 'like', '%'. $buscar . '%')->orderBy('id', 'desc')->paginate(10);
        }
        

        return [
            'pagination' => [
                'total'        => $tallas->total(),
                'current_page' => $tallas->currentPage(),
                'per_page'     => $tallas->perPage(),
                'last_page'    => $tallas->lastPage(),
                'from'         => $tallas->firstItem(),
                'to'           => $tallas->lastItem(),
            ],
            'tallas' => $tallas
        ];
    }

    public function selectTalla(Request $request){
        if (!$request->ajax()) return redirect('/');
        $tallas = Talla::where('condicion','=','1')
        ->select('id','talla')->orderBy('talla', 'asc')->get();
        return ['tallas' => $tallas];
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $tallas = new Talla();
        $tallas->talla = $request->talla;
        $tallas->descripcion = $request->descripcion;
        $tallas->condicion = '1';
        $tallas->save();
    }
  

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $tallas = Talla::findOrFail($request->id);
        $tallas->talla = $request->talla;
        $tallas->descripcion = $request->descripcion;
        $tallas->condicion = '1';
        $tallas->save();
    }

    public function desactivar(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $tallas = Talla::findOrFail($request->id);
        $tallas->condicion = '0';
        $tallas->save();
    }

    public function activar(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $tallas = Talla::findOrFail($request->id);
        $tallas->condicion = '1';
        $tallas->save();
    }

    
}
