<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Venta extends Model
{
    protected $table = 'ventas';
    protected $primaryKey = 'id';
    protected $fillable =[
        'idcliente', 
        'idusuario',
        'tipo_comprobante',
        'serie_comprobante',
        'num_comprobante',
        'fecha_hora',
        'impuesto',
        'total',
        'estado'
        // 'monto_pagado',
        // 'monto_deuda',
        // 'metodo_pago'
    ];

    public function categoria(){
        return $this->belongsTo('App\Categoria');
    }
    public function tipo_articulo(){
        return $this->belongsTo('App\TipoArticulo');
    }
    public function marca(){
        return $this->belongsTo('App\Marca');
    }
    public function talla(){
        return $this->belongsTo('App\Talla');
    }
    public function color(){
        return $this->belongsTo('App\Color');
    }
    public function centrocosto(){
        return $this->belongsTo('App\CentroCosto');
    }
    
    // Relación con DetalleVenta (una venta tiene muchos detalles)
    public function detalles()
    {
        return $this->hasMany(DetalleVenta::class, 'idventa');
    }
    
    // Relación con Cartera (una venta puede tener una cartera)
    public function cartera()
    {
        return $this->hasOne(Cartera::class, 'idventa_cart');
    }
    
    // Relación con Persona (cliente)
    public function cliente()
    {
        return $this->belongsTo(Persona::class, 'idcliente');
    }
    
    // Relación con User (usuario que realizó la venta)
    public function usuario()
    {
        return $this->belongsTo(User::class, 'idusuario');
    }
      
}


