<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCarteraTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cartera', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('cliente_id')->unsigned();
            $table->foreign('cliente_id')->references('id')->on('personas');
            $table->integer('idventa_cart')->unsigned();
            $table->foreign('idventa_cart')->references('id')->on('ventas');
            $table->decimal('total_deuda', 11, 2)->default(0);
            $table->decimal('compras', 11, 2)->default(0);
            $table->integer('cuotas')->default(1);
            $table->date('fecha_compr_pago');
            $table->decimal('total_abono', 11, 2)->default(0);
            $table->decimal('descuento', 11, 2)->default(0);
            $table->decimal('devolucion', 11, 2)->default(0);
            $table->decimal('saldo_actual', 11, 2)->default(0);
            $table->enum('estado_cart', ['Pendiente', 'Pagado', 'Parcial'])->default('Pendiente');
            $table->text('observaciones')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cartera');
    }
} 