<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetalleCarteraTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_cartera', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('idcartera')->unsigned();
            $table->foreign('idcartera')->references('id')->on('cartera');
            $table->integer('articulo_id')->unsigned();
            $table->foreign('articulo_id')->references('id')->on('articulos');
            $table->integer('centrocosto_id')->unsigned()->nullable();
            $table->foreign('centrocosto_id')->references('id')->on('centrocosto');
            $table->decimal('valor_venta_articulo', 11, 2);
            $table->integer('cantidad')->default(1);
            $table->decimal('compra', 11, 2);
            $table->date('fecha_venta');
            $table->decimal('pago_incompl', 11, 2)->default(0);
            $table->decimal('deuda', 11, 2)->default(0);
            $table->decimal('abono', 11, 2)->default(0);
            $table->date('fecha_abono')->nullable();
            $table->decimal('descuento', 11, 2)->default(0);
            $table->decimal('devolucion', 11, 2)->default(0);
            $table->decimal('saldo_actual', 11, 2)->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_cartera');
    }
} 