<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPaymentFieldsToVentasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ventas', function (Blueprint $table) {
            $table->decimal('monto_pagado', 11, 2)->default(0)->after('total');
            $table->decimal('monto_deuda', 11, 2)->default(0)->after('monto_pagado');
            $table->enum('metodo_pago', ['Efectivo', 'Tarjeta', 'Transferencia', 'Credito'])->default('Efectivo')->after('monto_deuda');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ventas', function (Blueprint $table) {
            $table->dropColumn(['monto_pagado', 'monto_deuda', 'metodo_pago']);
        });
    }
} 