<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Listado Detalle Ingresos</title>
    <!-- Incluye CSS de DataTables y Bootstrap -->
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/3.1.2/css/buttons.dataTables.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    
</head>
<body>

<div class="container mt-5">
    <h1 class="mb-4">Listado Detalle Ingresos</h1>

    <table class="table table-bordered table-striped table-hover dataTable js-exportable" id="DataTables_Table_1" role="grid" aria-describedby="DataTables_Table_1_info">
        
        <thead>
                                <tr>
                                        <th>Usuario</th>
                                        <th>Proveedor</th>
                                        <th>Tipo Comprobante</th>
                                        <th>Serie Comprobante</th>
                                        <th>Número Comprobante</th>
                                        <th>Fecha Hora</th>
                                        <th>Código</th>
                                        <th>Referencia</th>
                                        <th>Articulo</th>
                                        <th>Tipo de Articulo</th>
                                        <th>Talla</th>
                                        <th>Color</th>
                                        <th>Marca</th>
                                        <th>Cantidad</th>
                                        <th>Valor Unidad</th>
                                        <th>Total</th>
                                        <th>Impuesto</th>
                                        <th>Estado</th>
                                        <th>Centro de Costo</th>
                                </tr>
                            </thead>
        <tbody>
            @foreach($ingresos as $ingreso)
            <tr>
                <td>{{ $ingreso->usuario }}</td>
                <td>{{ $ingreso->nombre }}</td>
                <td>{{ $ingreso->tipo_comprobante }}</td>
                <td>{{ $ingreso->serie_comprobante }}</td>
                <td>{{ $ingreso->num_comprobante }}</td>
                <td>{{ $ingreso->fecha_hora }}</td>
                <td>{{ $ingreso->codigo }}</td>
                <td>{{ $ingreso->referencia }}</td>
                <td>{{ $ingreso->nombreArt }}</td>
                <td>{{ $ingreso->nombreTipArt }}</td>
                <td>{{ $ingreso->talla }}</td>
                <td>{{ $ingreso->color }}</td>
                <td>{{ $ingreso->nombreMar }}</td>
                <td>{{ $ingreso->cantidad }}</td>
                <td>{{ $ingreso->precio }}</td>
                <td>{{ $ingreso->cantidad*$ingreso->precio }}</td>
                <td>{{ $ingreso->impuesto }}</td>
                <td>{{ $ingreso->estado }}</td>
                <td>{{ $ingreso->nombreCC }}</td>
        
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.js"></script>
<script src="https://cdn.datatables.net/2.1.8/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/buttons/3.1.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/3.1.2/js/buttons.dataTables.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/3.1.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/3.1.2/js/buttons.print.min.js"></script>

<script>
    $(document).ready(function() {
    $('#DataTables_Table_1').DataTable({
        dom: 'Bfrtip', // Necesario para que los botones aparezcan
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
    });
});
</script>

</body>
</html>