<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/articulo', 'ArticuloController@index');

Route::group(['middleware'=>['guest']],function(){
    Route::get('/','Auth\LoginController@showLoginForm');
    Route::post('/login', 'Auth\LoginController@login')->name('login');
});

Route::group(['middleware'=>['auth']],function(){
    
    Route::post('/logout', 'Auth\LoginController@logout')->name('logout');
    Route::get('/dashboard', 'DashboardController');
    //Notificaciones 
    Route::post('/notification/get', 'NotificationController@get'); 
    
    Route::get('/main', function () {
        return view('contenido/contenido');
    })->name('main');

    Route::group(['middleware' => ['Almacenista']], function () {
        Route::get('/categoria', 'CategoriaController@index');
        Route::post('/categoria/registrar', 'CategoriaController@store');
        Route::put('/categoria/actualizar', 'CategoriaController@update');
        Route::put('/categoria/desactivar', 'CategoriaController@desactivar');
        Route::put('/categoria/activar', 'CategoriaController@activar');
        Route::get('/categoria/selectCategoria', 'CategoriaController@selectCategoria');

        Route::get('/centrocosto', 'CentroCostoController@index');
        Route::post('/centrocosto/registrar', 'CentroCostoController@store');
        Route::put('/centrocosto/actualizar', 'CentroCostoController@update');
        Route::put('/centrocosto/desactivar', 'CentroCostoController@desactivar');
        Route::put('/centrocosto/activar', 'CentroCostoController@activar');
        Route::get('/centrocosto/selectCentroCosto', 'CentroCostoController@selectCentroCosto');

        Route::get('/articulo', 'ArticuloController@index');
        Route::post('/articulo/registrar', 'ArticuloController@store');
        Route::put('/articulo/actualizar', 'ArticuloController@update');
        Route::put('/articulo/desactivar', 'ArticuloController@desactivar');
        Route::put('/articulo/activar', 'ArticuloController@activar');
        Route::get('/articulo/buscarArticulo', 'ArticuloController@buscarArticulo');
        Route::get('/articulo/listarArticulo', 'ArticuloController@listarArticulo');
        Route::get('/articulo/listarPdf','ArticuloController@listarPdf')->name('articulos_pdf');

        Route::get('/tipo_articulo', 'TipoArticuloController@index');
        Route::post('/tipo_articulo/registrar', 'TipoArticuloController@store');
        Route::put('/tipo_articulo/actualizar', 'TipoArticuloController@update');
        Route::put('/tipo_articulo/desactivar', 'TipoArticuloController@desactivar');
        Route::put('/tipo_articulo/activar', 'TipoArticuloController@activar');
        Route::get('/tipo_articulo/selectTipoArticulo', 'TipoArticuloController@selectTipoArticulo');

        Route::get('/talla', 'TallaController@index');
        Route::post('/talla/registrar', 'TallaController@store');
        Route::put('/talla/actualizar', 'TallaController@update');
        Route::put('/talla/desactivar', 'TallaController@desactivar');
        Route::put('/talla/activar', 'TallaController@activar');
        Route::get('/talla/selectTalla', 'TallaController@selectTalla');

        Route::get('/color', 'ColorController@index');
        Route::post('/color/registrar', 'ColorController@store');
        Route::put('/color/actualizar', 'ColorController@update');
        Route::put('/color/desactivar', 'ColorController@desactivar');
        Route::put('/color/activar', 'ColorController@activar');
        Route::get('/color/selectColor', 'ColorController@selectColor');

        Route::get('/marca', 'MarcaController@index');
        Route::post('/marca/registrar', 'MarcaController@store');
        Route::put('/marca/actualizar', 'MarcaController@update');
        Route::put('/marca/desactivar', 'MarcaController@desactivar');
        Route::put('/marca/activar', 'MarcaController@activar');
        Route::get('/marca/selectMarca', 'MarcaController@selectMarca');

        Route::get('/proveedor', 'ProveedorController@index');
        Route::post('/proveedor/registrar', 'ProveedorController@store');
        Route::put('/proveedor/actualizar', 'ProveedorController@update');
        Route::get('/proveedor/selectProveedor', 'ProveedorController@selectProveedor');

        Route::get('/ingreso', 'IngresoController@index');
        Route::get('/detalleingreso', ['as' => 'contenido.detalleingreso', 'uses' => 'IngresoController@detalleingreso']);
        Route::post('/ingreso/registrar', 'IngresoController@store');
        Route::put('/ingreso/desactivar', 'IngresoController@desactivar');
        Route::get('/ingreso/obtenerCabecera', 'IngresoController@obtenerCabecera');
        Route::get('/ingreso/obtenerDetalles', 'IngresoController@obtenerDetalles');

    });

    Route::group(['middleware' => ['Vendedor']], function () {
        Route::get('/cliente', 'ClienteController@index');
        Route::post('/cliente/registrar', 'ClienteController@store');
        Route::put('/cliente/actualizar', 'ClienteController@update');
        Route::get('/cliente/selectCliente', 'ClienteController@selectCliente');

        Route::get('/cartera', 'CarteraController@index');
        Route::post('/cartera/registrar', 'CarteraController@store');
        Route::get('/cartera/selectCliente', 'CarteraController@selectCliente');
        Route::get('/cartera/testData', 'CarteraController@testData');
        Route::get('/cartera/resumenCliente', 'CarteraController@obtenerResumenCliente');
        Route::post('/cartera/registrarAbono', 'CarteraController@registrarAbono');
        Route::get('/cartera/detalle/{id}', 'CarteraController@obtenerDetalle');
        Route::get('/cartera/verificar', 'CarteraController@verificarEstado');
        Route::get('/cartera/resumen', 'CarteraController@obtenerResumenGeneral');
        Route::get('/cartera/pdf/{id}', 'CarteraController@generarPDF');
 
        Route::get('/articulo/buscarArticuloVenta', 'ArticuloController@buscarArticuloVenta');
        Route::get('/articulo/listarArticuloVenta', 'ArticuloController@listarArticuloVenta');

        Route::get('/venta', 'VentaController@index');
        Route::get('/detalleventa', ['as' => 'contenido.detalleventa', 'uses' => 'VentaController@detalleventa']);
        Route::post('/venta/registrar', 'VentaController@store');
        Route::put('/venta/desactivar', 'VentaController@desactivar');
        Route::get('/venta/obtenerCabecera', 'VentaController@obtenerCabecera');
        Route::get('/venta/obtenerDetalles', 'VentaController@obtenerDetalles');
        Route::get('/venta/pdf/{id}','VentaController@pdf')->name('venta_pdf');
    });

    Route::group(['middleware' => ['Administrador']], function () {
        
        Route::get('/categoria', 'CategoriaController@index');
        Route::post('/categoria/registrar', 'CategoriaController@store');
        Route::put('/categoria/actualizar', 'CategoriaController@update');
        Route::put('/categoria/desactivar', 'CategoriaController@desactivar');
        Route::put('/categoria/activar', 'CategoriaController@activar');
        Route::get('/categoria/selectCategoria', 'CategoriaController@selectCategoria');

        Route::get('/centrocosto', 'CentroCostoController@index');
        Route::post('/centrocosto/registrar', 'CentroCostoController@store');
        Route::put('/centrocosto/actualizar', 'CentroCostoController@update');
        Route::put('/centrocosto/desactivar', 'CentroCostoController@desactivar');
        Route::put('/centrocosto/activar', 'CentroCostoController@activar');
        Route::get('/centrocosto/selectCentroCosto', 'CentroCostoController@selectCentroCosto');
        
        Route::get('/articulo', 'ArticuloController@index');
        Route::get('/inventario', ['as' => 'contenido.inventario', 'uses' => 'ArticuloController@consolidadoArt']);
        Route::post('/articulo/registrar', 'ArticuloController@store');
        Route::put('/articulo/actualizar', 'ArticuloController@update');
        Route::put('/articulo/desactivar', 'ArticuloController@desactivar');
        Route::put('/articulo/activar', 'ArticuloController@activar');
        Route::get('/articulo/buscarArticulo', 'ArticuloController@buscarArticulo');
        Route::get('/articulo/listarArticulo', 'ArticuloController@listarArticulo');
        Route::get('/articulo/buscarArticuloVenta', 'ArticuloController@buscarArticuloVenta');
        Route::get('/articulo/listarArticuloVenta', 'ArticuloController@listarArticuloVenta');
        Route::get('/articulo/listarPdf','ArticuloController@listarPdf')->name('articulos_pdf');

        Route::get('/tipo_articulo', 'TipoArticuloController@index');
        Route::post('/tipo_articulo/registrar', 'TipoArticuloController@store');
        Route::put('/tipo_articulo/actualizar', 'TipoArticuloController@update');
        Route::put('/tipo_articulo/desactivar', 'TipoArticuloController@desactivar');
        Route::put('/tipo_articulo/activar', 'TipoArticuloController@activar');
        Route::get('/tipo_articulo/selectTipoArticulo', 'TipoArticuloController@selectTipoArticulo');

        Route::get('/talla', 'TallaController@index');
        Route::post('/talla/registrar', 'TallaController@store');
        Route::put('/talla/actualizar', 'TallaController@update');
        Route::put('/talla/desactivar', 'TallaController@desactivar');
        Route::put('/talla/activar', 'TallaController@activar');
        Route::get('/talla/selectTalla', 'TallaController@selectTalla');

        Route::get('/color', 'ColorController@index');
        Route::post('/color/registrar', 'ColorController@store');
        Route::put('/color/actualizar', 'ColorController@update');
        Route::put('/color/desactivar', 'ColorController@desactivar');
        Route::put('/color/activar', 'ColorController@activar');
        Route::get('/color/selectColor', 'ColorController@selectColor');

        Route::get('/marca', 'MarcaController@index');
        Route::post('/marca/registrar', 'MarcaController@store');
        Route::put('/marca/actualizar', 'MarcaController@update');
        Route::put('/marca/desactivar', 'MarcaController@desactivar');
        Route::put('/marca/activar', 'MarcaController@activar');
        Route::get('/marca/selectMarca', 'MarcaController@selectMarca');

        Route::get('/proveedor', 'ProveedorController@index');
        Route::post('/proveedor/registrar', 'ProveedorController@store');
        Route::put('/proveedor/actualizar', 'ProveedorController@update');
        Route::get('/proveedor/selectProveedor', 'ProveedorController@selectProveedor');

        Route::get('/cartera', 'CarteraController@index');
        Route::post('/cartera/registrar', 'CarteraController@store');
        Route::get('/cartera/selectCliente', 'CarteraController@selectCliente');
        Route::get('/cartera/testData', 'CarteraController@testData');
        Route::get('/cartera/resumenCliente', 'CarteraController@obtenerResumenCliente');
        Route::post('/cartera/registrarAbono', 'CarteraController@registrarAbono');
        Route::get('/cartera/detalle/{id}', 'CarteraController@obtenerDetalle');
        Route::get('/cartera/verificar', 'CarteraController@verificarEstado');
        Route::get('/cartera/resumen', 'CarteraController@obtenerResumenGeneral');
        Route::get('/cartera/pdf/{id}', 'CarteraController@generarPDF');
    

        Route::get('/ingreso', 'IngresoController@index');
        Route::get('/detalleingreso', ['as' => 'contenido.detalleingreso', 'uses' => 'IngresoController@detalleingreso']);
        Route::post('/ingreso/registrar', 'IngresoController@store');
        Route::put('/ingreso/desactivar', 'IngresoController@desactivar');
        Route::get('/ingreso/obtenerCabecera', 'IngresoController@obtenerCabecera');
        Route::get('/ingreso/obtenerDetalles', 'IngresoController@obtenerDetalles');
        
        Route::get('/cliente', 'ClienteController@index');
        Route::post('/cliente/registrar', 'ClienteController@store');
        Route::put('/cliente/actualizar', 'ClienteController@update');
        Route::get('/cliente/selectCliente', 'ClienteController@selectCliente');

        Route::get('/venta', 'VentaController@index');
        Route::get('/detalleventa', ['as' => 'contenido.detalleventa', 'uses' => 'VentaController@detalleventa']);
        Route::post('/venta/registrar', 'VentaController@store');
        Route::put('/venta/desactivar', 'VentaController@desactivar');
        Route::get('/venta/obtenerCabecera', 'VentaController@obtenerCabecera');
        Route::get('/venta/obtenerDetalles', 'VentaController@obtenerDetalles');
        Route::get('/venta/pdf/{id}','VentaController@pdf')->name('venta_pdf');

        Route::get('/rol', 'RolController@index');
        Route::get('/rol/selectRol', 'RolController@selectRol');
        
        Route::get('/user', 'UserController@index');
        Route::post('/user/registrar', 'UserController@store');
        Route::put('/user/actualizar', 'UserController@update');
        Route::put('/user/desactivar', 'UserController@desactivar');
        Route::put('/user/activar', 'UserController@activar');
        Route::get('/user/selectUsuario', 'UserController@selectUsuario');
    });

});

//Route::get('/home', 'HomeController@index')->name('home');
