<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Reporte de Cartera</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .header h1 {
            color: #333;
            margin: 0;
        }
        .info-section {
            margin-bottom: 20px;
        }
        .info-section h3 {
            color: #666;
            border-bottom: 1px solid #ccc;
            padding-bottom: 5px;
        }
        .info-row {
            display: flex;
            margin-bottom: 5px;
        }
        .info-label {
            font-weight: bold;
            width: 150px;
        }
        .info-value {
            flex: 1;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .table th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .total-row {
            background-color: #f9f9f9;
            font-weight: bold;
        }
        .status-badge {
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: bold;
        }
        .status-pendiente {
            background-color: #ffcccc;
            color: #cc0000;
        }
        .status-parcial {
            background-color: #fff2cc;
            color: #cc6600;
        }
        .status-pagado {
            background-color: #ccffcc;
            color: #006600;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>REPORTE DE CARTERA</h1>
        <p>Fecha de generación: <?php echo e(date('d/m/Y H:i:s')); ?></p>
    </div>

    <div class="info-section">
        <h3>Información de la Cartera</h3>
        <div class="info-row">
            <div class="info-label">ID Cartera:</div>
            <div class="info-value"><?php echo e($cartera->id); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Cliente:</div>
            <div class="info-value"><?php echo e($cartera->cliente ? $cartera->cliente->nombre : 'N/A'); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Documento:</div>
            <div class="info-value"><?php echo e($cartera->cliente ? $cartera->cliente->num_documento : 'N/A'); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Venta #:</div>
            <div class="info-value"><?php echo e($cartera->venta ? $cartera->venta->num_comprobante : 'N/A'); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Fecha de Venta:</div>
            <div class="info-value"><?php echo e(date('d/m/Y', strtotime($cartera->fecha_compr_pago))); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Estado:</div>
            <div class="info-value">
                <span class="status-badge status-<?php echo e(strtolower($cartera->estado_cart)); ?>">
                    <?php echo e($cartera->estado_cart); ?>

                </span>
            </div>
        </div>
    </div>

    <div class="info-section">
        <h3>Resumen Financiero</h3>
        <div class="info-row">
            <div class="info-label">Total Deuda:</div>
            <div class="info-value">$<?php echo e(number_format($cartera->total_deuda, 2)); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Total Abonado:</div>
            <div class="info-value">$<?php echo e(number_format($cartera->total_abono, 2)); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Saldo Actual:</div>
            <div class="info-value">$<?php echo e(number_format($cartera->saldo_actual, 2)); ?></div>
        </div>
    </div>

    <div class="info-section">
        <h3>Detalles por Artículo</h3>
        <table class="table">
            <thead>
                <tr>
                    <th>Artículo</th>
                    <th class="text-center">Cantidad</th>
                    <th class="text-right">Valor Venta</th>
                    <th class="text-right">Pago Incompleto</th>
                    <th class="text-right">Deuda</th>
                    <th class="text-right">Abono</th>
                    <th class="text-right">Saldo Actual</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($detalle->articulo ? $detalle->articulo->nombre : 'N/A'); ?></td>
                    <td class="text-center"><?php echo e($detalle->cantidad); ?></td>
                    <td class="text-right">$<?php echo e(number_format($detalle->valor_venta_articulo, 2)); ?></td>
                    <td class="text-right">$<?php echo e(number_format($detalle->pago_incompl, 2)); ?></td>
                    <td class="text-right">$<?php echo e(number_format($detalle->deuda, 2)); ?></td>
                    <td class="text-right">$<?php echo e(number_format($detalle->abono, 2)); ?></td>
                    <td class="text-right">$<?php echo e(number_format($detalle->saldo_actual, 2)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
                <tr class="total-row">
                    <td colspan="2"><strong>TOTALES</strong></td>
                    <td class="text-right"><strong>$<?php echo e(number_format($detalles->sum('valor_venta_articulo'), 2)); ?></strong></td>
                    <td class="text-right"><strong>$<?php echo e(number_format($detalles->sum('pago_incompl'), 2)); ?></strong></td>
                    <td class="text-right"><strong>$<?php echo e(number_format($detalles->sum('deuda'), 2)); ?></strong></td>
                    <td class="text-right"><strong>$<?php echo e(number_format($detalles->sum('abono'), 2)); ?></strong></td>
                    <td class="text-right"><strong>$<?php echo e(number_format($detalles->sum('saldo_actual'), 2)); ?></strong></td>
                </tr>
            </tfoot>
        </table>
    </div>

    <div style="margin-top: 30px; text-align: center; font-size: 10px; color: #666;">
        <p>Este documento fue generado automáticamente por el sistema de gestión de cartera.</p>
        <p>Fecha y hora: <?php echo e(date('d/m/Y H:i:s')); ?></p>
    </div>
</body>
</html> 