<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Cartera extends Model
{
    protected $table = 'cartera';
    protected $primaryKey = 'id';
    protected $fillable =[
        'cliente_id',
        'idventa_cart', 
        'total_deuda',
        'compras',
        'cuotas',
        'fecha_compr_pago',
        'total_abono',
        'descuento',
        'devolucion',
        'saldo_actual',
        'estado_cart'
    ];
    public $timestamps = true;

    public function venta(){
        return $this->belongsTo('App\Venta');
    }
    public function cliente(){
        return $this->belongsTo('App\User');
    }
      
}