<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use App\Cartera;
use App\DetalleCartera;

class CarteraController extends Controller
{
    public function index(Request $request)
    {
        if (!$request->ajax()) return redirect('/');

        $buscar = $request->buscar;
        $criterio = $request->criterio;
        
        if ($buscar==''){
            $carteras = Cartera::join('personas','cartera.cliente_id','=','personas.id')
            ->select('personas.id','personas.nombre','personas.num_documento',
            'personas.direccion','personas.telefono','personas.email','cartera.idventa_cart',
            'cartera.total_deuda','cartera.compras','cartera.cuotas','cartera.fecha_compr_pago',
            'cartera.total_abono','cartera.descuento','cartera.devolucion','cartera.saldo_actual',
            'cartera.estado_cart')
            ->orderBy('personas.id', 'desc')->paginate(10);
        }
        else{
            $carteras = Cartera::join('personas','cartera.cliente_id','=','personas.id')
            ->select('personas.id','personas.nombre','personas.num_documento',
            'personas.direccion','personas.telefono','personas.email','cartera.idventa_cart ',
            'cartera.total_deuda','cartera.compras','cartera.cuotas','cartera.fecha_compr_pago',
            'cartera.total_abono','cartera.descuento','cartera.devolucion','cartera.saldo_actual',
            'cartera.estado_cart')
            ->where('personas.nombre'.$criterio, 'like', '%'. $buscar . '%')->orderBy('personas.id', 'desc')->paginate(10);
        }
        
        return [
            'pagination' => [
                'total'        => $carteras->total(),
                'current_page' => $carteras->currentPage(),
                'per_page'     => $carteras->perPage(),
                'last_page'    => $carteras->lastPage(),
                'from'         => $carteras->firstItem(),
                'to'           => $carteras->lastItem(),
            ],
            'carteras' => $carteras
        ];
    }

    public function selectUsuario(Request $request){
        if (!$request->ajax()) return redirect('/');
        $usuarios = User::where('condicion','=','1')
        ->where('idrol','=',4)
        ->select('id','usuario')->orderBy('usuario', 'asc')->get();
        return ['usuarios' => $usuarios];
    }

    public function store(Request $request)
    {
        if (!$request->ajax()) return redirect('/');

        try{
            DB::beginTransaction();

            $mytime= Carbon::now('America/Bogota');

            $cartera = new Cartera();
            $cartera->cliente_id = $request->cliente_id;
            $cartera->total_deuda = $request->total_deuda;
            $cartera->compras = $request->compras;
            $cartera->fecha_compr_pago = $request->fecha_compr_pago;
            $cartera->cuotas = $request->cuotas;
            $cartera->total_abono = $request->total_abono;
            $cartera->descuento = $request->descuento;
            $cartera->devolucion = $request->devolucion;
            $cartera->saldo_actual = $request->saldo_actual;
            $cartera->estado_cart = $request->estado_cart;
            $cartera->save();

            $detallescartera = $request->data;//Array de detalles
            //Recorro todos los elementos

            foreach($detallescartera as $dc=>$detcar)
            {
                $detallecartera = new DetalleCartera();
                $detallecartera->idcartera = $cartera->id;
                $detallecartera->articulo_id = $detcar['articulo_id'];
                $detallecartera->valor_venta_articulo = $detcar['valor_venta_articulo'];
                $detallecartera->cantidad = $detcar['cantidad'];
                $detallecartera->compra = $detcar['compra'];
                $detallecartera->fecha_venta = $detcar['fecha_venta'];
                $detallecartera->pago_incompl = $detcar['pago_incompl'];
                $detallecartera->deuda = $detcar['deuda'];
                $detallecartera->abono = $detcar['abono'];
                $detallecartera->fecha_abono = $detcar['fecha_abono'];
                $detallecartera->descuento = $detcar['descuento'];
                $detallecartera->devolucion = $detcar['devolucion'];
                $detallecartera->saldo_actual = $detcar['saldo_actual'];
            }

            DB::commit();
        } catch (Exception $e){
            DB::rollBack();
        }
    }

}
