<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\CentroCosto;

class CentroCostoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if (!$request->ajax()) return redirect('/');

        $buscar = $request->buscar;
        $criterio = $request->criterio;
        
        if ($buscar==''){
            $centrocostos = CentroCosto::orderBy('id', 'desc')->paginate(10);
        }
        else{
            $centrocostos = CentroCosto::where($criterio, 'like', '%'. $buscar . '%')->orderBy('id', 'desc')->paginate(10);
        }
        

        return [
            'pagination' => [
                'total'        => $centrocostos->total(),
                'current_page' => $centrocostos->currentPage(),
                'per_page'     => $centrocostos->perPage(),
                'last_page'    => $centrocostos->lastPage(),
                'from'         => $centrocostos->firstItem(),
                'to'           => $centrocostos->lastItem(),
            ],
            'centrocostos' => $centrocostos
        ];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

     public function selectCentroCosto(Request $request){
        if (!$request->ajax()) return redirect('/');
        $centrocostos = CentroCosto::where('condicion','=','1')
        ->select('id','nombre')->orderBy('id', 'asc')->get();
        return ['centrocostos' => $centrocostos];
    }

    public function store(Request $request)
    {
        //if (!$request->ajax()) return redirect('/');
        $centrocostos = new CentroCosto();
        $centrocostos->nombre = $request->nombre;
        $centrocostos->descripcion = $request->descripcion;
        $centrocostos->condicion = '1';
        $centrocostos->save();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //if (!$request->ajax()) return redirect('/');
        $centrocostos = CentroCosto::findOrFail($request->id);
        $centrocostos->nombre = $request->nombre;
        $centrocostos->descripcion = $request->descripcion;
        $centrocostos->condicion = '1';
        $centrocostos->save();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function desactivar(Request $request)
    {
        //if (!$request->ajax()) return redirect('/');
        $centrocostos = CentroCosto::findOrFail($request->id);
        $centrocostos->condicion = '0';
        $centrocostos->save();
    }

    public function activar(Request $request)
    {
        //if (!$request->ajax()) return redirect('/');
        $centrocostos = CentroCosto::findOrFail($request->id);
        $centrocostos->condicion = '1';
        $centrocostos->save();
    }
}
