<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Listado Detalle Ventas</title>
    <!-- Incluye CSS de DataTables y Bootstrap -->
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/3.1.2/css/buttons.dataTables.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    
</head>
<body>

<div class="container mt-5">
    <h1 class="mb-4">Listado Detalle Ventas</h1>

    <table class="table table-bordered table-striped table-hover dataTable js-exportable" id="DataTables_Table_1" role="grid" aria-describedby="DataTables_Table_1_info">
        
        <thead>
            <tr>
                <th>ID Venta</th>
                <th>Fecha</th>
                <th>No. Comprobante</th>
                <th>Cliente</th>
                <th>Codigo</th>
                <th>Referencia</th>
                <th>Articulo</th>
                <th>Categoria</th>
                <th>Tipo</th>
                <th>Marca</th>
                <th>Talla</th>
                <th>Color</th>
                <th>Cantidad</th>
                <th>Valor</th>
                <th>Descuento</th>
                <th>Valor Total</th>
                <th>Tipo de Comprobante</th>
                <th>Centro de Costo</th>
            </tr>
        </thead>
        <tbody>
            @foreach($ventas as $venta)
            <tr>
                <td>{{ $venta->id }}</td>
                <td>{{ $venta->fecha_hora }}</td>
                <td>{{ $venta->num_comprobante }}</td>
                <td>{{ $venta->nombre }}</td>
                <td>{{ $venta->codigo }}</td>
                <td>{{ $venta->referencia }}</td>
                <td>{{ $venta->nombreArt }}</td>
                <td>{{ $venta->nombreCat }}</td>
                <td>{{ $venta->nombreTA }}</td>
                <td>{{ $venta->nombreMar }}</td>
                <td>{{ $venta->talla }}</td>
                <td>{{ $venta->color }}</td>
                <td>{{ $venta->cantidad }}</td>
                <td>{{ $venta->precio }}</td>
                <td>{{ $venta->descuento }}</td>
                <td>{{ ($venta->precio ?? 0) - ($venta->descuento ?? 0) }}</td>
                <td>{{ $venta->tipo_comprobante }}</td>
                <td>{{ $venta->nombreCC }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.js"></script>
<script src="https://cdn.datatables.net/2.1.8/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/buttons/3.1.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/3.1.2/js/buttons.dataTables.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/3.1.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/3.1.2/js/buttons.print.min.js"></script>

<script>
    $(document).ready(function() {
    $('#DataTables_Table_1').DataTable({
        dom: 'Bfrtip', // Necesario para que los botones aparezcan
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
    });
});
</script>

</body>
</html>