<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Listado Detalle Inventario</title>
    <!-- Incluye CSS de DataTables y Bootstrap -->
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/3.1.2/css/buttons.dataTables.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    
</head>
<body>

<div class="container mt-5">
    <h1 class="mb-4">Listado Detalle Inventario</h1>

    <table class="table table-bordered table-striped table-hover dataTable js-exportable" id="DataTables_Table_1" role="grid" aria-describedby="DataTables_Table_1_info">
        
        <thead>
            <tr>
                                    <th>Código</th>
                                    <th>Referencia</th>
                                    <th>Nombre</th>
                                    <th>Categoría</th>
                                    <th>Tipo</th>
                                    <th>Marca</th>
                                    <th>Talla</th>
                                    <th>Color</th>
                                    <th>Material</th>
                                    <th>Centro de Costo</th>
                                    <th>Precio Venta</th>
                                    <th>Stock</th>
                                    <th>Descripción</th>
                                    <th>Estado</th>
            </tr>
        </thead>
        <tbody>
            @foreach($articulos as $articulo)
            <tr>
                <td >{{ $articulo->codigo }}</td>
                                    <td >{{ $articulo->referencia }}</td>
                                    <td >{{ $articulo->nombre }}</td>
                                    <td >{{ $articulo->nombre_categoria }}</td>
                                    <td >{{ $articulo->nombre_tipo_arti }}</td>
                                    <td >{{ $articulo->nombre_marca }}</td>
                                    <td >{{ $articulo->talla }}</td>
                                    <td v-text="articulo.color">{{ $articulo->color }}</td>
                                    <td v-text="articulo.material">{{ $articulo->material }}</td>
                                    <td v-text="articulo.nombreCC">{{ $articulo->nombreCC }}</td>
                                    <td v-text="articulo.precio_venta">{{ $articulo->precio_venta }}</td>
                                    <td v-text="articulo.stock">{{ $articulo->stock }}</td>
                                    <td v-text="articulo.descripcion">{{ $articulo->descripcion }}</td>
                                    <td>
                                        @if($articulo->condicion==1)
                                            <span class="badge badge-success">Activo</span>
                                        @else
                                            <span class="badge badge-danger"> Desactivado</span>
                                    </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.js"></script>
<script src="https://cdn.datatables.net/2.1.8/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/buttons/3.1.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/3.1.2/js/buttons.dataTables.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/3.1.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/3.1.2/js/buttons.print.min.js"></script>

<script>
    $(document).ready(function() {
    $('#DataTables_Table_1').DataTable({
        dom: 'Bfrtip', // Necesario para que los botones aparezcan
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
    });
});
</script>

</body>
</html>