<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\TipoArticulo;
use Illuminate\Support\Facades\DB;

class TipoArticuloController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if (!$request->ajax()) return redirect('/');

        $buscar = $request->buscar;
        $criterio = $request->criterio;

        if ($buscar==''){
            $tipo_articulos = TipoArticulo::orderBy('id', 'desc')->paginate(10);
            //$tipo_articulos = DB::table('tipo_articulo as ta')->paginate(10);
            //->get();
            //$tipo_articulos = TipoArticulo::paginate(2);
        }
        else{
            $tipo_articulos = TipoArticulo::where($criterio, 'like', '%'. $buscar . '%')->orderBy('id', 'desc')->paginate(10);
        }

         
        //return $tipo_articulos;
        return [
            'pagination' => [
                'total'        => $tipo_articulos->total(),
                'current_page' => $tipo_articulos->currentPage(),
                'per_page'     => $tipo_articulos->perPage(),
                'last_page'    => $tipo_articulos->lastPage(),
                'from'         => $tipo_articulos->firstItem(),
                'to'           => $tipo_articulos->lastItem(),
            ],
            'tipo_articulos' => $tipo_articulos
        ];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

     public function selectTipoArticulo(Request $request){
        if (!$request->ajax()) return redirect('/');
        $tipo_articulos = TipoArticulo::where('condicion','=','1')
        ->select('id','nombre')->orderBy('nombre', 'asc')->get();
        return ['tipo_articulos' => $tipo_articulos];
    }

    public function store(Request $request)
    {
        if (!$request->ajax()) return redirect('/');  
        $tipo_articulo = new TipoArticulo();
        $tipo_articulo->nombre = $request->nombre;
        $tipo_articulo->descripcion = $request->descripcion;
        $tipo_articulo->condicion = '1';
        $tipo_articulo->save();
        
        /*
        TipoArticulo::create([
            'nombre'      => $_POST["nombre"],
            'descripcion'   => $_POST["descripcion"],
            'condicion'       => '1',
        ]);
        */
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $tipo_articulo = TipoArticulo::findOrFail($request->id);
        $tipo_articulo->nombre = $request->nombre;
        $tipo_articulo->descripcion = $request->descripcion;
        $tipo_articulo->condicion = '1';
        $tipo_articulo->save();
    }

    public function desactivar(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $tipo_articulo = TipoArticulo::findOrFail($request->id);
        $tipo_articulo->condicion = '0';
        $tipo_articulo->save();
    }

    public function activar(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $tipo_articulo = TipoArticulo::findOrFail($request->id);
        $tipo_articulo->condicion = '1';
        $tipo_articulo->save();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
