<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Ingreso extends Model
{
    protected $table = 'ingresos';
    protected $primaryKey = 'id';
    protected $fillable = [
        'idproveedor', 
        'idusuario',
        'tipo_comprobante',
        'serie_comprobante',
        'num_comprobante',
        'fecha_hora',
        'impuesto',
        'total',
        'estado'
     ];
     public function usuario()
     {
         return $this->belongsTo('App\User');
     }
     public function proveedor()
     {
         return $this->belongsTo('App\Proveedor');
     }
     public function articulo(){
        return $this->belongsTo('App\Articulo');
    }
     public function tipo_articulo(){
        return $this->belongsTo('App\TipoArticulo');
    }
    public function marca(){
        return $this->belongsTo('App\Marca');
    }
    public function talla(){
        return $this->belongsTo('App\Talla');
    }
    public function color(){
        return $this->belongsTo('App\Color');
    }
 
 
}
