<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Articulo;

class ArticuloController extends Controller
{
    public function index(Request $request)
    {
        if (!$request->ajax()) return redirect('/');

        $buscar = $request->buscar;
        $criterio = $request->criterio;
        
        if ($buscar==''){
            $articulos = Articulo::join('categorias','articulos.idcategoria','=','categorias.id')
            ->join('marca','articulos.idmarca','=','marca.id')
            ->join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
            ->join('talla','articulos.talla_id','=','talla.id')
            ->join('color','articulos.color_id','=','color.id')
            ->join('users','articulos.user_id','=','users.id')
            ->select('articulos.id','articulos.idcategoria','articulos.idmarca','articulos.tipo_articulo_id','articulos.talla_id',
            'articulos.color_id','articulos.user_id','articulos.codigo','articulos.referencia','articulos.nombre','articulos.material','categorias.nombre as nombre_categoria',
            'marca.nombre as nombre_marca','tipo_articulo.nombre as nombre_tipo_arti','talla.talla','color.color','users.usuario',
            'articulos.precio_venta','articulos.stock','articulos.descripcion','articulos.condicion')
            ->orderBy('articulos.id', 'desc')->paginate(10);
        }
        else{
            $articulos = Articulo::join('categorias','articulos.idcategoria','=','categorias.id')
            ->join('marca','articulos.idmarca','=','marca.id')
            ->join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
            ->join('talla','articulos.talla_id','=','talla.id')
            ->join('color','articulos.color_id','=','color.id')
            ->join('users','articulos.user_id','=','users.id')
            ->select('articulos.id','articulos.idcategoria','articulos.idmarca','articulos.tipo_articulo_id','articulos.talla_id',
            'articulos.color_id','articulos.user_id','articulos.codigo','articulos.referencia','articulos.nombre','articulos.material','categorias.nombre as nombre_categoria',
            'marca.nombre as nombre_marca','tipo_articulo.nombre as nombre_tipo_arti','talla.talla','color.color','users.usuario',
            'articulos.precio_venta','articulos.stock','articulos.descripcion','articulos.condicion')
            ->where('articulos.'.$criterio, 'like', '%'. $buscar . '%')
            ->orderBy('articulos.id', 'desc')->paginate(10);
        }
        

        return [
            'pagination' => [
                'total'        => $articulos->total(),
                'current_page' => $articulos->currentPage(),
                'per_page'     => $articulos->perPage(),
                'last_page'    => $articulos->lastPage(),
                'from'         => $articulos->firstItem(),
                'to'           => $articulos->lastItem(),
            ],
            'articulos' => $articulos
        ];
    }

    public function listarArticulo(Request $request)
    {
        if (!$request->ajax()) return redirect('/');

        $buscar = $request->buscar;
        $criterio = $request->criterio;
        
        if ($buscar==''){
            $articulos = Articulo::join('categorias','articulos.idcategoria','=','categorias.id')
            ->join('marca','articulos.idmarca','=','marca.id')
            ->join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
            ->join('talla','articulos.talla_id','=','talla.id')
            ->join('color','articulos.color_id','=','color.id')
            ->join('users','articulos.user_id','=','users.id')
            ->select('articulos.id','articulos.idcategoria','articulos.idmarca','articulos.tipo_articulo_id','articulos.talla_id',
            'articulos.color_id','articulos.user_id','articulos.codigo','articulos.referencia','articulos.nombre','articulos.material','categorias.nombre as nombre_categoria',
            'marca.nombre as nombre_marca','tipo_articulo.nombre as nombre_tipo_arti','talla.talla','color.color','users.usuario',
            'articulos.precio_venta','articulos.stock','articulos.descripcion','articulos.condicion')
            ->orderBy('articulos.id', 'desc')->paginate(10);
        }
        else{
            $articulos = Articulo::join('categorias','articulos.idcategoria','=','categorias.id')
            ->join('marca','articulos.idmarca','=','marca.id')
            ->join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
            ->join('talla','articulos.talla_id','=','talla.id')
            ->join('color','articulos.color_id','=','color.id')
            ->join('users','articulos.user_id','=','users.id')
            ->select('articulos.id','articulos.idcategoria','articulos.idmarca','articulos.tipo_articulo_id','articulos.talla_id',
            'articulos.color_id','articulos.user_id','articulos.codigo','articulos.referencia','articulos.nombre','articulos.material','categorias.nombre as nombre_categoria',
            'marca.nombre as nombre_marca','tipo_articulo.nombre as nombre_tipo_arti','talla.talla','color.color','users.usuario',
            'articulos.precio_venta','articulos.stock','articulos.descripcion','articulos.condicion')
            ->where('articulos.'.$criterio, 'like', '%'. $buscar . '%')
            ->orderBy('articulos.id', 'desc')->paginate(10);
        }
        

        return ['articulos' => $articulos];
    }
 
    public function listarArticuloVenta(Request $request)
    {
        if (!$request->ajax()) return redirect('/');

        $buscar = $request->buscar;
        $criterio = $request->criterio;
        
        if ($buscar==''){
            $articulos = Articulo::join('categorias','articulos.idcategoria','=','categorias.id')
            ->join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
            ->join('marca','articulos.idmarca','=','marca.id')
            ->join('talla','articulos.talla_id','=','talla.id')
            ->join('color','articulos.color_id','=','color.id')
            ->select('articulos.id','articulos.idcategoria','articulos.codigo','articulos.referencia','articulos.nombre',
            'categorias.nombre as nombre_categoria','articulos.precio_venta','articulos.stock','articulos.descripcion',
            'articulos.condicion','tipo_articulo.nombre as nombreTipArt','marca.nombre as nombre_marca','talla.talla','color.color')
            ->where('articulos.stock','>','0')
            ->orderBy('articulos.id', 'desc')->paginate(10);
        }
        else{
            $articulos = Articulo::join('categorias','articulos.idcategoria','=','categorias.id')
            ->join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
            ->join('marca','articulos.idmarca','=','marca.id')
            ->join('talla','articulos.talla_id','=','talla.id')
            ->join('color','articulos.color_id','=','color.id')
            ->select('articulos.id','articulos.idcategoria','articulos.codigo','articulos.referencia','articulos.nombre',
            'categorias.nombre as nombre_categoria','articulos.precio_venta','articulos.stock',
            'articulos.descripcion','articulos.condicion','tipo_articulo.nombre as nombreTipArt','marca.nombre as nombre_marca',
            'talla.talla','color.color')
            ->where('articulos.'.$criterio, 'like', '%'. $buscar . '%')
            ->where('articulos.stock','>','0')
            ->orderBy('articulos.id', 'desc')->paginate(10);
        }
        

        return ['articulos' => $articulos];
    }

    public function listarPdf(){

        $articulos = Articulo::join('categorias','articulos.idcategoria','=','categorias.id')
            ->join('marca','articulos.idmarca','=','marca.id')
            ->join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
            ->join('talla','articulos.talla_id','=','talla.id')
            ->join('color','articulos.color_id','=','color.id')
            ->join('users','articulos.user_id','=','users.id')
            ->select('articulos.id','articulos.idcategoria','articulos.idmarca','articulos.tipo_articulo_id','articulos.talla_id',
            'articulos.color_id','articulos.user_id','articulos.codigo','articulos.referencia','articulos.nombre','articulos.material',
            'categorias.nombre as nombre_categoria','marca.nombre as nombre_marca','tipo_articulo.nombre as nombre_tipo_arti',
            'talla.talla','color.color','users.usuario','articulos.precio_venta','articulos.stock','articulos.descripcion',
            'articulos.condicion')
            ->orderBy('articulos.nombre', 'desc')->get();

        $cont=Articulo::count();

        $pdf = \PDF::loadView('pdf.articulospdf',['articulos'=>$articulos,'cont'=>$cont]);
        return $pdf->setPaper('a4','landscape')->download('articulos.pdf');
    }

    public function buscarArticulo(Request $request){
        if (!$request->ajax()) return redirect('/');

        $filtro = $request->filtro;
        $articulos = Articulo::join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
            ->join('categorias','articulos.idcategoria','=','categorias.id')
            ->join('talla','articulos.talla_id','=','talla.id')
            ->join('color','articulos.color_id','=','color.id')
            ->join('marca','articulos.idmarca','=','marca.id')
            ->where('articulos.codigo','=', $filtro) 
            ->select('articulos.id','articulos.nombre',
            'tipo_articulo.nombre as nombreTipArt','articulos.codigo','articulos.referencia',
            'talla.talla','color.color','marca.nombre as nombreMar','articulos.user_id as idProp',
            'categorias.nombre as nombre_categoria')
            ->orderBy('articulos.nombre', 'asc')
            ->take(1)
            ->get();

        return ['articulos' => $articulos];
    }

    public function buscarArticuloVenta(Request $request){
        if (!$request->ajax()) return redirect('/');

        $filtro = $request->filtro;
        $articulos = Articulo::join('tipo_articulo','articulos.tipo_articulo_id','=','tipo_articulo.id')
        ->join('categorias','articulos.idcategoria','=','categorias.id')
        ->join('marca','articulos.idmarca','=','marca.id')
        ->join('talla','articulos.talla_id','=','talla.id')
        ->join('color','articulos.color_id','=','color.id')
        ->select('articulos.id','articulos.nombre','articulos.stock','articulos.precio_venta',
        'tipo_articulo.nombre as nombreTipArt','categorias.nombre as nombre_categoria','marca.nombre as nombre_marca','talla.talla',
        'color.color','articulos.codigo','articulos.referencia')
        ->where('articulos.codigo','=', $filtro)
        ->where('articulos.stock','>','0')
        ->orderBy('articulos.nombre', 'asc')
        ->take(1)->get();

        return ['articulos' => $articulos];
    }
    
    public function store(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $articulo = new Articulo();
        $articulo->idcategoria = $request->idcategoria;
        $articulo->idmarca = $request->idmarca;
        $articulo->codigo = $request->codigo;
        $articulo->nombre = $request->nombre;
        $articulo->referencia = $request->referencia;
        $articulo->tipo_articulo_id = $request->tipo_articulo_id;
        $articulo->talla_id = $request->talla_id;
        $articulo->color_id = $request->color_id;
        $articulo->user_id = $request->user_id;
        $articulo->material = $request->material;
        $articulo->precio_venta = $request->precio_venta;
        $articulo->stock = $request->stock;
        $articulo->descripcion = $request->descripcion;
        $articulo->condicion = '1';
        $articulo->save();
    }
    public function update(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $articulo = Articulo::findOrFail($request->id);
        $articulo->idcategoria = $request->idcategoria;
        $articulo->idmarca = $request->idmarca;
        $articulo->codigo = $request->codigo;
        $articulo->nombre = $request->nombre;
        $articulo->referencia = $request->referencia;
        $articulo->tipo_articulo_id = $request->tipo_articulo_id;
        $articulo->talla_id = $request->talla_id;
        $articulo->color_id = $request->color_id;
        $articulo->user_id = $request->user_id;
        $articulo->material = $request->material;
        $articulo->precio_venta = $request->precio_venta;
        $articulo->stock = $request->stock;
        $articulo->descripcion = $request->descripcion;
        $articulo->condicion = '1';
        $articulo->save();
    }

    public function desactivar(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $articulo = Articulo::findOrFail($request->id);
        $articulo->condicion = '0';
        $articulo->save();
    }

    public function activar(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $articulo = Articulo::findOrFail($request->id);
        $articulo->condicion = '1';
        $articulo->save();
    }

}
