<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
//use Illuminate\Support\Facades\DB;
use App\Color;

class ColorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if (!$request->ajax()) return redirect('/');

        $buscar = $request->buscar;
        $criterio = $request->criterio;
        
        if ($buscar==''){
            $colores = Color::orderBy('id', 'desc')->paginate(10);
        }
        else{
            $colores = Color::where($criterio, 'like', '%'. $buscar . '%')->orderBy('id', 'desc')->paginate(10);
        }
        

        return [
            'pagination' => [
                'total'        => $colores->total(),
                'current_page' => $colores->currentPage(),
                'per_page'     => $colores->perPage(),
                'last_page'    => $colores->lastPage(),
                'from'         => $colores->firstItem(),
                'to'           => $colores->lastItem(),
            ],
            'colores' => $colores
        ];
    }

    public function selectColor(Request $request){
        if (!$request->ajax()) return redirect('/');
        $colores = Color::where('condicion','=','1')
        ->select('id','color')->orderBy('color', 'asc')->get();
        return ['colores' => $colores];
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $colores = new Color();
        $colores->color = $request->color;
        $colores->condicion = '1';
        $colores->save();
    }
  

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $colores = Color::findOrFail($request->id);
        $colores->color = $request->color;
        $colores->condicion = '1';
        $colores->save();
    }

    public function desactivar(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $colores = Color::findOrFail($request->id);
        $colores->condicion = '0';
        $colores->save();
    }

    public function activar(Request $request)
    {
        if (!$request->ajax()) return redirect('/');
        $colores = Color::findOrFail($request->id);
        $colores->condicion = '1';
        $colores->save();
    }

    
}
