<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Venta extends Model
{
    protected $table = 'ventas';
    protected $primaryKey = 'id';
    protected $fillable =[
        'idcliente', 
        'idusuario',
        'tipo_comprobante',
        'serie_comprobante',
        'num_comprobante',
        'fecha_hora',
        'impuesto',
        'total',
        'estado'
    ];

    public function categoria(){
        return $this->belongsTo('App\Categoria');
    }
    public function tipo_articulo(){
        return $this->belongsTo('App\TipoArticulo');
    }
    public function marca(){
        return $this->belongsTo('App\Marca');
    }
    public function talla(){
        return $this->belongsTo('App\Talla');
    }
    public function color(){
        return $this->belongsTo('App\Color');
    }
    public function usuario(){
        return $this->belongsTo('App\User');
    }
      
}


